using System;
using System.Collections.Generic;
using System.Linq;
using System.Data;
using VIRP.AHOBPR.BO;

namespace VIRP.AHOBPR.DAL
{
	public partial class REGISTRANT_DEPLOYMENTDB : VIRP.DBUtils
	{
		#region Fields
		#endregion

		#region Constructors

		public REGISTRANT_DEPLOYMENTDB()
		{
		}

		#endregion

		#region Properties
		#endregion

		#region Methods

		public REGISTRANT_DEPLOYMENT GetItem(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 REGISTRANT_DEPLOYMENT_ID)
		{
			REGISTRANT_DEPLOYMENT objReturn = null;

			try
			{
				using (AHOBPRDBDataContext dbContext = GetAHOBPRDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					objReturn = dbContext.usp_REGISTRANT_DEPLOYMENT_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, REGISTRANT_DEPLOYMENT_ID).FirstOrDefault();
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
		}

		public List<REGISTRANT_DEPLOYMENT> GetItems(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
		{
			List<REGISTRANT_DEPLOYMENT> objReturn = null;

			try
			{
				using (AHOBPRDBDataContext dbContext = GetAHOBPRDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					objReturn = dbContext.usp_REGISTRANT_DEPLOYMENT_getitems(CURRENT_USER, CURRENT_REGISTRY_ID).ToList();
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
		}

        public List<REGISTRANT_DEPLOYMENT> GetItemsByRegistrantId(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, int REGISTRANT_ID)
        {
            List<REGISTRANT_DEPLOYMENT> objReturn = null;

            try
            {
                using (AHOBPRDBDataContext dbContext = GetAHOBPRDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_REGISTRANT_DEPLOYMENT_getitemsByRegistrantId(CURRENT_USER, CURRENT_REGISTRY_ID, REGISTRANT_ID).ToList();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public int Save(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, REGISTRANT_DEPLOYMENT objSave)
		{
			Int32? objReturn = objSave.REGISTRANT_DEPLOYMENT_ID;

			try
			{
				using (AHOBPRDBDataContext dbContext = GetAHOBPRDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					dbContext.usp_REGISTRANT_DEPLOYMENT_save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave.BPR_DEPLOYMENT_ID, DateTime.Now, objSave.CREATEDBY, objSave.DEPLOYMENT_BASE, objSave.DEPLOYMENT_COUNTRY, objSave.DEPLOYMENT_END_DATE, objSave.DEPLOYMENT_START_DATE, objSave.DEPLOYMENT_UIC, objSave.DUTY_PROJECT_CODE, objSave.IS_ELIGIBLE_FLAG, objSave.IS_GULF_WAR_VETERAN_FLAG, objSave.LAST_UPDATED_DATE, objSave.PREVIOUS_UPDATED_DATE, objSave.PREVIOUS_VALUES, ref objReturn, objSave.REGISTRANT_ID, objSave.STD_BRANCH_OF_SERVICE_ID, objSave.STD_COMPONENT_ID, objSave.STD_DEPLOYMENT_STAGE_ID, objSave.STD_PAYPLAN_ID, DateTime.Now, objSave.UPDATEDBY, objSave.USER_ENTERED_FLAG, objSave.USER_VERIFIED_FLAG);
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn.GetValueOrDefault();
		}

		public Boolean Delete(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 REGISTRANT_DEPLOYMENT_ID)
		{
			Boolean objReturn = false;

			try
			{
				using (AHOBPRDBDataContext dbContext = GetAHOBPRDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					dbContext.usp_REGISTRANT_DEPLOYMENT_delete(CURRENT_USER, CURRENT_REGISTRY_ID, REGISTRANT_DEPLOYMENT_ID);
					objReturn = true;
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
		}

		#endregion
	}
}
